import java.awt.EventQueue;

import javax.swing.*;

//2014.10.30
import java.awt.*;
import java.awt.event.*;

import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinNT.HRESULT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;


public class SC510N1 {

	private JFrame frame;
	
	//api
	public interface Ole32 extends StdCallLibrary {

	    Ole32 INSTANCE = (Ole32) Native.loadLibrary("Ole32", Ole32.class);
	    public HRESULT CoInitialize(Pointer p);
	    public HRESULT CoUninitialize();	    
	}
	
	public interface Cqcap extends StdCallLibrary{
		Cqcap instance = (Cqcap) Native.loadLibrary("QCAP.X64", Cqcap.class);
		public int QCAP_QUERY_ENCODER_TYPE_CAP(int INPUT);
		public int QCAP_GET_VERSION(IntByReference pMajorVersion, IntByReference pMinorVersion);
		
		public int QCAP_SET_AUDIO_INPUT(Pointer pDevice, int nInput);
		public int QCAP_SET_VIDEO_INPUT(Pointer pDevice, int nInput);
		public int QCAP_SET_VIDEO_DEINTERLACE( Pointer pDevice , int nType  );
		public int QCAP_SET_VIDEO_BRIGHTNESS(Pointer pDevice, int nValue);
		public int QCAP_GET_VIDEO_BRIGHTNESS(Pointer pDevice, IntByReference nValue);
		public int QCAP_SET_VIDEO_CONTRAST(Pointer pDevice, int nValue);
		public int QCAP_GET_VIDEO_CONTRAST(Pointer pDevice, IntByReference nValue);
		public int QCAP_SET_VIDEO_HUE(Pointer pDevice, int nValue);
		public int QCAP_GET_VIDEO_HUE(Pointer pDevice, IntByReference nValue);
		public int QCAP_SET_VIDEO_SATURATION(Pointer pDevice, int nValue);
		public int QCAP_GET_VIDEO_SATURATION(Pointer pDevice, IntByReference nValue);
		public int QCAP_SET_VIDEO_SHARPNESS(Pointer pDevice, int nValue);
		public int QCAP_GET_VIDEO_SHARPNESS(Pointer pDevice, IntByReference nValue);
		
		public int QCAP_CREATE(String pszDevName, int iDevNum, int hAttachedWindow, PointerByReference ppDevice, int bThumbDraw, int bMaintainAspectRatio);
		public int QCAP_RUN(Pointer pDevice);
		public int QCAP_STOP(Pointer pDevice);
		public int QCAP_DESTROY(Pointer pDevice);
		public int QCAP_SET_AUDIO_RECORD_PROPERTY(Pointer pDevice, int iRecNum, int nEncoderType, int nEncoderFormat);
		public int QCAP_SET_VIDEO_RECORD_PROPERTY(Pointer pDevice, int iRecNum, int nEncoderType, int nEncoderFormat, int nRecordMode, int nQuality, int nBitRate, int nGOP, int nAspectRatioX, int nAspectRatioY, int nDownscaleMode );
		public int QCAP_START_RECORD(Pointer pDevice, int iRecNum, String pszFilePathName, int dwFlags , double dVideoDelayTime, double dAudioDelayTime, double dSegmentDurationTime, int nSegmentDurationSizeKB);
		public int QCAP_STOP_RECORD(Pointer pDevice, int iRecNum, int bIsAsync, int nMilliseconds);
		public int QCAP_SNAPSHOT_BMP(Pointer pDevice, String pszFilePathName, int bIsAsync, int nMilliseconds);
		public int QCAP_SNAPSHOT_JPG(Pointer pDevice, String pszFilePathName, int nQuality, int bIsAsync, int nMilliseconds);
		
	}

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		
		//dll path
		System.setProperty("jna.library.path", "./libs");
		
		// INITIALIZE COM RESOURCE
		//Ole32.INSTANCE.CoInitialize(null);

		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					SC510N1 window = new SC510N1();
					window.frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
		
		// UNINITIALIZE COM RESOURCE
		//Ole32.INSTANCE.CoUninitialize();
	}

	/**
	 * Create the application.
	 */
	public SC510N1() {	
		// INITIALIZE COM RESOURCE
		Ole32.INSTANCE.CoInitialize(null);
		initialize();
	}
	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		
		frame = new JFrame();
		frame.setTitle("SC510N1");
		frame.setResizable(false);
		frame.setSize(745, 323);
		frame.setLocationRelativeTo(null);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.getContentPane().setLayout(null);
		
		//INITIALIZE MEMBER VARIABLES
		String m_strChipName = "SA7160 PCI";
		String m_BMPFileName = "snapshot_bmp.bmp";
		String m_JPGFileName = "snapshot_jpg.jpg";
		PointerByReference m_hCapDev;
		m_hCapDev = new PointerByReference(null);
		
		frame.addWindowListener(new WindowAdapter()
    	{
    		public void windowClosing(WindowEvent e)
    		{
    			Cqcap.instance.QCAP_STOP(m_hCapDev.getValue());
	        	Cqcap.instance.QCAP_DESTROY(m_hCapDev.getValue());
    			//System.exit(0);
    			frame.dispose();
    		}
    	}
    		
		);
		
		//PreviewFrame
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		double width = screenSize.getWidth();
		double height = screenSize.getHeight();
		
		JFrame PreviewFrame = new JFrame("Preview Window Demo");
		PreviewFrame.setSize((int)width/2, (int)height/2);
		//PreviewFrame.setLocationRelativeTo(null);
		//PreviewFrame.setUndecorated(true);
		PreviewFrame.setVisible(true);
		long a = Native.getComponentID(PreviewFrame);		
		Cqcap.instance.QCAP_CREATE(m_strChipName, 0, (int)a, m_hCapDev, 1, 0);
		Cqcap.instance.QCAP_RUN(m_hCapDev.getValue());		
		
		//VIDEO INPUT
		JButton b_VideoInput = new JButton("Video Input");
		b_VideoInput.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				//frame and panel
				JFrame VideoInputFrame;
				VideoInputFrame = new JFrame( "VIDEO INPUT");
				VideoInputFrame.setSize(600, 80);
				VideoInputFrame.setResizable(false);
				VideoInputFrame.setLocationRelativeTo(null);
				JPanel VideoInputPanel = new JPanel();
		        //radio button
				JRadioButton Composit = new JRadioButton();
				Composit.setText("COMPOSITE");
				//Composit.setBounds(10, 10, 100, 23);
				JRadioButton SVideo = new JRadioButton();
				SVideo.setText("SVIDEO");
				//SVideo.setBounds(10, 40, 100, 23);
				JRadioButton HDMI = new JRadioButton();
				HDMI.setText("HDMI");
				HDMI.setBounds(10, 70, 100, 23);
				JRadioButton DVI_D = new JRadioButton();
				DVI_D.setText("DVI_D");
				//DVI_D.setBounds(10, 100, 100, 23);
				JRadioButton Components = new JRadioButton();
				Components.setText("COMPONENTS");
				//Components.setBounds(10, 130, 100, 23);
				JRadioButton DVI_A = new JRadioButton();
				DVI_A.setText("DVI_A");
				//DVI_A.setBounds(10, 160, 100, 23);
				JRadioButton SDI = new JRadioButton();
				SDI.setText("SDI");
				//SDI.setBounds(10, 190, 100, 23);
				JRadioButton AUTO = new JRadioButton();
				AUTO.setText("AUTO");
				//AUTO.setBounds(10, 220, 100, 23);
				//radio btn listener
				Composit.addActionListener(new ActionListener(){
					public void actionPerformed(ActionEvent e) {
						Cqcap.instance.QCAP_SET_VIDEO_INPUT(m_hCapDev.getValue(), 0);
					}
				});
				SVideo.addActionListener(new ActionListener(){
					public void actionPerformed(ActionEvent e) {
						Cqcap.instance.QCAP_SET_VIDEO_INPUT(m_hCapDev.getValue(), 1);
					}
				});
				HDMI.addActionListener(new ActionListener(){
					public void actionPerformed(ActionEvent e) {
						Cqcap.instance.QCAP_SET_VIDEO_INPUT(m_hCapDev.getValue(), 2);
					}
				});
				DVI_D.addActionListener(new ActionListener(){
					public void actionPerformed(ActionEvent e) {
						Cqcap.instance.QCAP_SET_VIDEO_INPUT(m_hCapDev.getValue(), 3);
					}
				});
				Components.addActionListener(new ActionListener(){
					public void actionPerformed(ActionEvent e) {
						Cqcap.instance.QCAP_SET_VIDEO_INPUT(m_hCapDev.getValue(), 4);
					}
				});
				DVI_A.addActionListener(new ActionListener(){
					public void actionPerformed(ActionEvent e) {
						Cqcap.instance.QCAP_SET_VIDEO_INPUT(m_hCapDev.getValue(), 5);
					}
				});
				SDI.addActionListener(new ActionListener(){
					public void actionPerformed(ActionEvent e) {
						Cqcap.instance.QCAP_SET_VIDEO_INPUT(m_hCapDev.getValue(), 6);
					}
				});
				AUTO.addActionListener(new ActionListener(){
					public void actionPerformed(ActionEvent e) {
						Cqcap.instance.QCAP_SET_VIDEO_INPUT(m_hCapDev.getValue(), 7);
					}
				});				
				//group add btn
				ButtonGroup VideoGroup = new ButtonGroup();
				VideoGroup.add(Composit);
				VideoGroup.add(SVideo);
				VideoGroup.add(HDMI);
				VideoGroup.add(DVI_D);
				VideoGroup.add(Components);
				VideoGroup.add(DVI_A);
				VideoGroup.add(SDI);
				VideoGroup.add(AUTO);				
				//Panel add btn
				VideoInputPanel.add(Composit);
				VideoInputPanel.add(SVideo);
				VideoInputPanel.add(HDMI);
				VideoInputPanel.add(DVI_D);
				VideoInputPanel.add(Components);
				VideoInputPanel.add(DVI_A);
				VideoInputPanel.add(SDI);
				VideoInputPanel.add(AUTO);
				//frame add panel
				VideoInputFrame.getContentPane().add(VideoInputPanel);				
				VideoInputFrame.setVisible(true);				
		        //close frame
				VideoInputFrame.addWindowListener(new WindowAdapter()
		        	{
		        		public void windowClosing(WindowEvent e)
		        		{
		        			//System.exit(0);
		        			VideoInputFrame.dispose();
		        		}
		        	}
		        		
		        );
			}
		});
		b_VideoInput.setBounds(10, 11, 115, 46);
		frame.getContentPane().add(b_VideoInput);
		
		
		//AUDIO INPUT
		JButton b_AudioInput = new JButton("Audio Input");
		b_AudioInput.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				//frame and panel
				JFrame AudioInputFrame;
				AudioInputFrame = new JFrame( "AUDIO INPUT");
				AudioInputFrame.setSize(600, 80);
				AudioInputFrame.setResizable(false);
				AudioInputFrame.setLocationRelativeTo(null);
				JPanel AudioInputPanel = new JPanel();
				//radio button
				JRadioButton Embeedded = new JRadioButton();
				Embeedded.setText("EMBEDDED_AUDIO");
				//Embeedded.setBounds(10, 10, 250, 23);
				JRadioButton LineIn = new JRadioButton();
				LineIn.setText("LINE_IN");
				//LineIn.setBounds(10, 10, 250, 23);
				JRadioButton Microphone = new JRadioButton();
				Microphone.setText("SOUNDCARD_MICROPHONE");
				//Microphone.setBounds(10, 10, 250, 23);
				JRadioButton SoundcardLineIn = new JRadioButton();
				SoundcardLineIn.setText("SOUNDCARD_LINE_IN");
				//SoundcardLineIn.setBounds(10, 10, 250, 23);
				//radio btn listener
				Embeedded.addActionListener(new ActionListener(){
					public void actionPerformed(ActionEvent e) {
						Cqcap.instance.QCAP_SET_AUDIO_INPUT(m_hCapDev.getValue(), 0);
					}
				});
				LineIn.addActionListener(new ActionListener(){
					public void actionPerformed(ActionEvent e) {
						Cqcap.instance.QCAP_SET_AUDIO_INPUT(m_hCapDev.getValue(), 1);
					}
				});
				Microphone.addActionListener(new ActionListener(){
					public void actionPerformed(ActionEvent e) {
						Cqcap.instance.QCAP_SET_AUDIO_INPUT(m_hCapDev.getValue(), 2);
					}
				});
				SoundcardLineIn.addActionListener(new ActionListener(){
					public void actionPerformed(ActionEvent e) {
						Cqcap.instance.QCAP_SET_AUDIO_INPUT(m_hCapDev.getValue(), 3);
					}
				});
				//group add btn
				ButtonGroup AudioGroup = new ButtonGroup();
				AudioGroup.add(Embeedded);
				AudioGroup.add(LineIn);
				AudioGroup.add(Microphone);
				AudioGroup.add(SoundcardLineIn);
				//Panel add btn
				AudioInputPanel.add(Embeedded);
				AudioInputPanel.add(LineIn);
				AudioInputPanel.add(Microphone);
				AudioInputPanel.add(SoundcardLineIn);
				//frame add panel
				AudioInputFrame.getContentPane().add(AudioInputPanel);				
				AudioInputFrame.setVisible(true);
				//close frame
				AudioInputFrame.addWindowListener(new WindowAdapter()
	        	{
	        		public void windowClosing(WindowEvent e)
	        		{
	        			//System.exit(0);
	        			AudioInputFrame.dispose();
	        		}
	        	}
	        		
	        );
				
			}
		});
		b_AudioInput.setBounds(139, 11, 110, 46);
		frame.getContentPane().add(b_AudioInput);
		
		
		//VIDEO QUALITY
		JButton b_VideoQuality = new JButton("Video Quality");
		b_VideoQuality.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {	
				IntByReference get_BRIGHTNESS;
				get_BRIGHTNESS = new IntByReference(0);
				Cqcap.instance.QCAP_GET_VIDEO_BRIGHTNESS(m_hCapDev.getValue(), get_BRIGHTNESS);
				
				IntByReference get_CONTRAST;
				get_CONTRAST = new IntByReference(0);
				Cqcap.instance.QCAP_GET_VIDEO_CONTRAST(m_hCapDev.getValue(), get_CONTRAST);
				
				IntByReference get_HUE;
				get_HUE = new IntByReference(0);
				Cqcap.instance.QCAP_GET_VIDEO_HUE(m_hCapDev.getValue(), get_HUE);
				
				IntByReference get_SATURATION;
				get_SATURATION = new IntByReference(0);
				Cqcap.instance.QCAP_GET_VIDEO_SATURATION(m_hCapDev.getValue(), get_SATURATION);
				
				IntByReference get_SHARPNESS;
				get_SHARPNESS = new IntByReference(0);
				Cqcap.instance.QCAP_GET_VIDEO_SHARPNESS(m_hCapDev.getValue(), get_SHARPNESS);
				//frame and panel
				JFrame VideoQualityFrame;
				VideoQualityFrame = new JFrame( "Video Quality");
				VideoQualityFrame.setSize(400, 150);
				VideoQualityFrame.setResizable(false);
				VideoQualityFrame.setLocationRelativeTo(null);
				JPanel VideoQualityPanel = new JPanel();
				//slider
				JSlider slider_BRIGHTNESS = new JSlider(JSlider.HORIZONTAL,0,255,(int)get_BRIGHTNESS.getValue());
				JLabel Label_BRIGHTNESS_value = new JLabel();
				Label_BRIGHTNESS_value.setText("BRIGHTNESS:"+ (slider_BRIGHTNESS.getValue()));
				
				JSlider slider_CONTRAST = new JSlider(JSlider.HORIZONTAL,0,255,(int)get_CONTRAST.getValue());
				JLabel Label_CONTRAST_value = new JLabel();
				Label_CONTRAST_value.setText("   CONTRAST:"+ (slider_CONTRAST.getValue()));
				
				JSlider slider_HUE = new JSlider(JSlider.HORIZONTAL,0,255,(int)get_HUE.getValue());
				JLabel Label_HUE_value = new JLabel();
				Label_HUE_value.setText("                 HUE:"+ (slider_HUE.getValue()));
				
				JSlider slider_SATURATION = new JSlider(JSlider.HORIZONTAL,0,255,(int)get_SATURATION.getValue());
				JLabel Label_SATURATION_value = new JLabel();
				Label_SATURATION_value.setText("SATURATION:"+ (slider_SATURATION.getValue()));
				
				JSlider slider_SHARPNESS = new JSlider(JSlider.HORIZONTAL,0,255,(int)get_SHARPNESS.getValue());
				JLabel Label_SHARPNESS_value = new JLabel();
				Label_SHARPNESS_value.setText(" SHARPNESS:"+ (slider_SHARPNESS.getValue()));
				
				//JSlider listener
				slider_BRIGHTNESS.addChangeListener(new ChangeListener(){
					public void stateChanged(ChangeEvent e){
						Label_BRIGHTNESS_value.setText("BRIGHTNESS:" 
					            + ((JSlider)e.getSource()).getValue());
						Cqcap.instance.QCAP_SET_VIDEO_BRIGHTNESS(m_hCapDev.getValue(), ((JSlider)e.getSource()).getValue());
					}				
				});
				slider_CONTRAST.addChangeListener(new ChangeListener(){
					public void stateChanged(ChangeEvent e){
						Label_CONTRAST_value.setText("   CONTRAST:" 
					            + ((JSlider)e.getSource()).getValue());
						Cqcap.instance.QCAP_SET_VIDEO_CONTRAST(m_hCapDev.getValue(), ((JSlider)e.getSource()).getValue());
					}				
				});
				slider_HUE.addChangeListener(new ChangeListener(){
					public void stateChanged(ChangeEvent e){
						Label_HUE_value.setText("                 HUE:" 
					            + ((JSlider)e.getSource()).getValue());
						Cqcap.instance.QCAP_SET_VIDEO_HUE(m_hCapDev.getValue(), ((JSlider)e.getSource()).getValue());
					}				
				});
				slider_SATURATION.addChangeListener(new ChangeListener(){
					public void stateChanged(ChangeEvent e){
						Label_SATURATION_value.setText("SATURATION:" 
					            + ((JSlider)e.getSource()).getValue());
						Cqcap.instance.QCAP_SET_VIDEO_SATURATION(m_hCapDev.getValue(), ((JSlider)e.getSource()).getValue());
					}				
				});
				slider_SHARPNESS.addChangeListener(new ChangeListener(){
					public void stateChanged(ChangeEvent e){
						Label_SHARPNESS_value.setText(" SHARPNESS:" 
					            + ((JSlider)e.getSource()).getValue());
						Cqcap.instance.QCAP_SET_VIDEO_SHARPNESS(m_hCapDev.getValue(), ((JSlider)e.getSource()).getValue());
					}				
				});

				
				//Panel add slider
				//VideoQualityPanel.add(BRIGHTNESS);
				VideoQualityPanel.add(slider_BRIGHTNESS);
				VideoQualityPanel.add(Label_BRIGHTNESS_value);				
				//VideoQualityPanel.add(CONTRAST);
				VideoQualityPanel.add(slider_CONTRAST);
				VideoQualityPanel.add(Label_CONTRAST_value);				
				//VideoQualityPanel.add(HUE);
				VideoQualityPanel.add(slider_HUE);
				VideoQualityPanel.add(Label_HUE_value);				
				//VideoQualityPanel.add(SATURATION);
				VideoQualityPanel.add(slider_SATURATION);
				VideoQualityPanel.add(Label_SATURATION_value);				
				//VideoQualityPanel.add(SHARPNESS);
				VideoQualityPanel.add(slider_SHARPNESS);
				VideoQualityPanel.add(Label_SHARPNESS_value);
				//frame add panel
				VideoQualityFrame.getContentPane().add(VideoQualityPanel);				
				VideoQualityFrame.setVisible(true);
				//
				
				//close frame
				VideoQualityFrame.addWindowListener(new WindowAdapter()
	        	{
	        		public void windowClosing(WindowEvent e)
	        		{
	        			//System.exit(0);
	        			VideoQualityFrame.dispose();
	        		}
	        	}
				);
			}
		});
		b_VideoQuality.setBounds(259, 11, 110, 46);
		frame.getContentPane().add(b_VideoQuality);
		
		
		//SNAPSHOT BMP
		JButton b_SnapshotBmp = new JButton("Snapshot bmp");
		b_SnapshotBmp.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Cqcap.instance.QCAP_SNAPSHOT_BMP(m_hCapDev.getValue(), m_BMPFileName, 1, 0 );
			}
		});
		b_SnapshotBmp.setBounds(10, 68, 115, 46);
		frame.getContentPane().add(b_SnapshotBmp);
		
		JTextPane BMPPath = new JTextPane();
		BMPPath.setEditable(false);
		BMPPath.setBounds(259, 70, 470, 20);
		frame.getContentPane().add(BMPPath);
		BMPPath.setText(System.getProperty("user.dir")+"\\snapshot_bmp.bmp");
		
		//SNAPSHOT JPG
		JButton b_SnapshotJpg = new JButton("Snapshot jpg");
		b_SnapshotJpg.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Cqcap.instance.QCAP_SNAPSHOT_JPG(m_hCapDev.getValue(), m_JPGFileName, 100, 1, 0 );
			}
		});
		b_SnapshotJpg.setBounds(139, 68, 110, 46);
		frame.getContentPane().add(b_SnapshotJpg);

		JTextPane JPGPath = new JTextPane();
		JPGPath.setEditable(false);
		JPGPath.setBounds(259, 93, 470, 20);
		frame.getContentPane().add(JPGPath);
		JPGPath.setText(System.getProperty("user.dir")+"\\Snapshot_jpg.jpg");
		
		//RECORD 1-1
		JCheckBox IntelGpuSupport1 = new JCheckBox("Intel GPU Support 1");
		IntelGpuSupport1.setBounds(259, 126, 150, 23);
		frame.getContentPane().add(IntelGpuSupport1);
		
		JRadioButton AVI1 = new JRadioButton("AVI (H.264 + PCM)");
		AVI1.setBounds(411, 125, 135, 25);		
		JRadioButton MP41 = new JRadioButton("MP4 (H.264 + AAC)");
		MP41.setBounds(555, 125, 135, 25);
		MP41.setSelected(true);
		ButtonGroup RECORDGroup1 = new ButtonGroup();
		RECORDGroup1.add(AVI1);
		RECORDGroup1.add(MP41);		
		frame.getContentPane().add(AVI1);
		frame.getContentPane().add(MP41);
		
		JTextPane RecordPath1 = new JTextPane();
		RecordPath1.setEditable(false);
		RecordPath1.setBounds(259, 150, 470, 20);
		RecordPath1.setText(System.getProperty("user.dir")+"\\unname1_1080_12M.mp4");
		frame.getContentPane().add(RecordPath1);
		
		AVI1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				RecordPath1.setText(System.getProperty("user.dir")+"\\unname1_1080_12M.avi");
			}
		});
		MP41.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				RecordPath1.setText(System.getProperty("user.dir")+"\\unname1_1080_12M.mp4");
			}
		});
		
		
		JButton b_StartRecord1 = new JButton("Record 1-1");
		b_StartRecord1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if(IntelGpuSupport1.isSelected())
				{
					Cqcap.instance.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev.getValue(), 0, 2, 0, 1, 8000, 12*1024*1024, 30, 0, 0, 0);
				}
				else
				{
					Cqcap.instance.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev.getValue(), 0, 0, 0, 1, 8000, 12*1024*1024, 30, 0, 0, 0);
				}	
				if(AVI1.isSelected())
				{
					Cqcap.instance.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev.getValue(), 0, 0, 0);
				}
				else
				{
					Cqcap.instance.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev.getValue(), 0, 0, 1);
				}
	        	Cqcap.instance.QCAP_START_RECORD(m_hCapDev.getValue(), 0, RecordPath1.getText(), 7, 0, 0 ,0 ,0 );
			}
		});
		b_StartRecord1.setBounds(10, 127, 115, 46);
		frame.getContentPane().add(b_StartRecord1);
		
		
		//STOP 1-1
		JButton b_StopRecord1 = new JButton("Stop 1-1");
		b_StopRecord1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Cqcap.instance.QCAP_STOP_RECORD(m_hCapDev.getValue(), 0, 1, 0);
			}
		});
		b_StopRecord1.setBounds(139, 126, 110, 46);
		frame.getContentPane().add(b_StopRecord1);
		
		
		//RECORD 1-2
		JCheckBox IntelGpuSupport2 = new JCheckBox("Intel GPU Support 2");
		IntelGpuSupport2.setBounds(259, 179, 150, 23);
		frame.getContentPane().add(IntelGpuSupport2);
		
		JRadioButton AVI2 = new JRadioButton("AVI (H.264 + PCM)");
		AVI2.setBounds(411, 178, 135, 25);		
		JRadioButton MP42 = new JRadioButton("MP4 (H.264 + AAC)");
		MP42.setBounds(555, 178, 135, 25);
		MP42.setSelected(true);
		ButtonGroup RECORDGroup2 = new ButtonGroup();
		RECORDGroup2.add(AVI2);
		RECORDGroup2.add(MP42);
		frame.getContentPane().add(AVI2);
		frame.getContentPane().add(MP42);
		
		JTextPane RecordPath2 = new JTextPane();
		RecordPath2.setEditable(false);
		RecordPath2.setBounds(259, 206, 470, 20);
		RecordPath2.setText(System.getProperty("user.dir")+"\\unname2_960_6M.mp4");
		frame.getContentPane().add(RecordPath2);
		
		AVI2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				RecordPath2.setText(System.getProperty("user.dir")+"\\unname2_960_6M.avi");
			}
		});
		MP42.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				RecordPath2.setText(System.getProperty("user.dir")+"\\unname2_960_6M.mp4");
			}
		});
		
		JButton b_StartRecord2 = new JButton("Record 1-2");
		b_StartRecord2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if(IntelGpuSupport2.isSelected())
				{
					Cqcap.instance.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev.getValue(), 1, 2, 0, 1, 8000, 6*1024*1024, 30, 0, 0, 2);
				}
				else
				{
					Cqcap.instance.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev.getValue(), 1, 0, 0, 1, 8000, 6*1024*1024, 30, 0, 0, 2);
				}
				Cqcap.instance.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev.getValue(), 1, 0, 1);
	        	Cqcap.instance.QCAP_START_RECORD(m_hCapDev.getValue(), 1, RecordPath2.getText(), 7, 0, 0 ,0 ,0 );
			}
		});
		b_StartRecord2.setBounds(10, 180, 115, 46);
		frame.getContentPane().add(b_StartRecord2);
		
		
		//STOP 1-2
		JButton b_StopRecord2 = new JButton("Stop 1-2");
		b_StopRecord2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Cqcap.instance.QCAP_STOP_RECORD(m_hCapDev.getValue(), 1, 1, 0);
			}
		});
		b_StopRecord2.setBounds(139, 180, 110, 46);
		frame.getContentPane().add(b_StopRecord2);
		
		
		//RECORD 1-3
		JCheckBox IntelGpuSupport3 = new JCheckBox("Intel GPU Support 3");
		IntelGpuSupport3.setBounds(259, 237, 150, 23);
		frame.getContentPane().add(IntelGpuSupport3);
		
		JRadioButton AVI3 = new JRadioButton("AVI (H.264 + PCM)");
		AVI3.setBounds(411, 236, 135, 25);	
		JRadioButton MP43 = new JRadioButton("MP4 (H.264 + AAC)");
		MP43.setBounds(555, 236, 135, 25);
		MP43.setSelected(true);
		ButtonGroup RECORDGroup3 = new ButtonGroup();
		RECORDGroup3.add(AVI3);
		RECORDGroup3.add(MP43);
		frame.getContentPane().add(AVI3);
		frame.getContentPane().add(MP43);
		
		JTextPane RecordPath3 = new JTextPane();
		RecordPath3.setEditable(false);
		RecordPath3.setBounds(259, 263, 470, 20);
		RecordPath3.setText(System.getProperty("user.dir")+"\\unname3_480_2M.mp4");
		frame.getContentPane().add(RecordPath3);
		
		AVI3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				RecordPath3.setText(System.getProperty("user.dir")+"\\unname3_480_2M.avi");
			}
		});
		MP43.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				RecordPath3.setText(System.getProperty("user.dir")+"\\unname3_480_2M.mp4");
			}
		});
		
		JButton b_StartRecord3 = new JButton("Record 1-3");
		b_StartRecord3.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if(IntelGpuSupport3.isSelected())
				{
					Cqcap.instance.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev.getValue(), 2, 2, 0, 1, 8000, 2*1024*1024, 30, 0, 0, 3);
				}
				else
				{
					Cqcap.instance.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev.getValue(), 2, 0, 0, 1, 8000, 2*1024*1024, 30, 0, 0, 3);
				}
				
				Cqcap.instance.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev.getValue(), 2, 0, 1);
	        	Cqcap.instance.QCAP_START_RECORD(m_hCapDev.getValue(), 2, RecordPath3.getText(), 7, 0, 0 ,0 ,0 );
			}
		});
		b_StartRecord3.setBounds(10, 237, 115, 46);
		frame.getContentPane().add(b_StartRecord3);
		
		
		//STOP 1-3
		JButton b_StopRecord3 = new JButton("Stop 1-3");
		b_StopRecord3.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Cqcap.instance.QCAP_STOP_RECORD(m_hCapDev.getValue(), 2, 1, 0);
			}
		});
		b_StopRecord3.setBounds(139, 238, 110, 46);
		frame.getContentPane().add(b_StopRecord3);
		
		//DEINTERLACE
		JCheckBox DEINTERLACE = new JCheckBox("AUTO DEINTERLACE");
		DEINTERLACE.setBounds(393, 23, 156, 23);
		DEINTERLACE.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if(DEINTERLACE.isSelected())
				{
					Cqcap.instance.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev.getValue(),1);
				}
				else
				{
					Cqcap.instance.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev.getValue(),0);
				}
			}
		});
		frame.getContentPane().add(DEINTERLACE);		

	}
}
